<?php
/**
 * Template: My Keyword Template
 * Context ID: keyword
 * URL Pattern: "/{item}/"
 *
 * === IMPORTANT ===
 * Please add your own <title> / <meta> tags here, using $dpg_current_item.
 * =================
 */

if ( ! defined('ABSPATH') || ! isset( $dpg_current_item ) ) {
    status_header(404);
    exit;
}

global $dpg_current_item, $dpg_current_slug;

get_header();
?>
<main class="site-content">
  <h1><?php esc_html_e( 'Keyword:', 'dynamic-seo-pages'); ?> <strong><?php echo esc_html( $dpg_current_item ); ?></strong></h1>
  <p><?php esc_html_e( 'Use shortcode for slug:', 'dynamic-seo-pages'); ?> <code><?php echo do_shortcode('[dpg_item field="slug"]'); ?></code></p>
</main>
<?php
get_footer();